#! /bin/bash

Logfile="Stdout"
Outputdir="."
Mode="Html"
Stylefile=".m2hs"
Recursive=""
Hypertext=""
TopIndex=""
GlobalIndes=""

get_info() {
# obtention des informations concernant le fichier

 line="`cat $1 | grep ^\.TH.*`" #recuperation de la ligne contenant la macro .TH
 line=`echo "$line" | sed s/^[^\ ]*\ //` #suppression de la macro

 # determination du titre : "title"
 test=`echo $line | sed s/^\"//` #test=line ssi line ne commence pas par un guillemet
 if [ "$test" = "$line" ] ; then title=`echo "$line" | sed s/\ .*//` #titre en un mot
				 line=`echo "$line" | sed s/^[^\ ]*\ //` #reste de la ligne apres le premier espace
 else 
      title=`echo "$test" | sed s/\".*$//` #titre s'arrete au prochain guillemet
      line=`echo $line | sed s/^\"[^\"]*\"//` #reste de la ligne apres le second guillemet
 fi

 #determination de la section
 test=`echo $line | sed s/^\"//`
 if [ "$test" = "$line" ] ; then section=`echo "$line" | sed s/\ .*//`
			         line=`echo "$line" | sed s/^[^\ ]*\ //`
 else section=`echo "$test" | sed s/\".*$//`
      line=`echo $line | sed s/^\"[^\"]*\"//`
 fi

 #determination de la date
 test=`echo $line | sed s/^\"//`
 if [ "$test" = "$line" ] ; then date=`echo "$line" | sed s/\ .*//`
			     line=`echo "$line" | sed s/^[^\ ]*\ //`
 else date=`echo "$test" | sed s/\".*$//`
      line=`echo $line | sed s/^\"[^\"]*\"//`
 fi

 #determination de la source
 test=`echo $line | sed s/^\"//`
 if [ "$test" = "$line" ] ; then source=`echo "$line" | sed s/\ .*//`
			     line=`echo "$line" | sed s/^[^\ ]*\ //`
 else source=`echo "$test" | sed s/\".*$//`
      line=`echo $line | sed s/^\"[^\"]*\"//`
 fi

 #determination du manuel
 test=`echo $line | sed s/^\"//`
 if [ "$test" = "$line" ] ; then manual=`echo "$line" | sed s/\ .*//`
			     line=`echo "$line" | sed s/^[^\ ]*\ //`
 else manual=`echo "$test" | sed s/\".*$//`
      line=`echo $line | sed s/^\"[^\"]*\"//`
 fi
}


#pour les redirections vers un fichier de log :
my_echo() {
if [ $Logfile = "Stdout" ] ; then
    echo $1
else
    echo $1 >> $Logfile
fi
}


#gestion des sequences d'echappement en mode html
traiter_echap() {
cat $1 | sed -f $Stylefile > $2
}


#idem en texte
traiter_echap_txt() {
cat $1 | sed -f "$Stylefile".txt > $2
}


#construction de l'index global
add_to_index() { #fichier d'entree sous la forme command.html
command=`echo $1 | sed "s/\..*//"` #suppression de l'extension
if [ "$GlobalIndex" ] ; then
    echo "<P><H3><A HREF=\"$1\">$command</A></H3>" >> "$Outputdir/"index.html
fi
}


#saisit les donnees du fichier $2 et les ecrit dans $1 a raison d'un mot par ligne
word() {
while read line ; do
    reste="$line"
    while [ "$reste" ] ; do
	word1=`echo "$reste" | (read wo res ; echo $wo)`
        reste=`echo "$reste" | (read wo res ; echo $res)`
	echo "$word1" >> $1
    done
done < $2
}


#gere l'aspect recursif du script
rec() {
file=`echo $1 | sed "s/.*\///" | sed "s/\..*//"`
line=`cat $1 | grep -n 'SEE ALSO'` #on considere le fichier uniquement a partir de cette section
if [ "$line" ] ; then #si elle existe...
    numb_inf=`echo $line | sed s/:.*//`
    numb_sup=$[$numb_inf + 1]
    tail_var=`echo $numb_sup | sed s/^/+/`
    tail $tail_var $1 > /tmp/m2h/also."$file"
    line2=`grep -n '\.SH' /tmp/m2h/also."$file" | head -1` #on s'arrete a la section suivante
    if [ "$line2" = "" ] ; then numb_inf2=`wc -l $1 | sed s/:.*//` # ou a la fin si c'est la derniere section
    else numb_sup2=`echo $line2 | sed s/:.*//`
	numb_inf2=$[$numb_sup2 - 1]
    fi
    head_var=`echo $numb_inf2 | sed s/^/-/`
    head $head_var /tmp/m2h/also."$file" > /tmp/m2h/also2."$file"
    cat /tmp/m2h/also2."$file" | sed -f .font | grep \([1-9]\) | sed "s/\ \(([1-9])\)/\1/g" > /tmp/m2h/commands3."$file" #on recupere les command(n)
    word /tmp/m2h/commands2."$file" /tmp/m2h/commands3."$file" #et uniquement eux...
    cat /tmp/m2h/commands2."$file" | grep \([1-9]\) | sed "s/(.*//" > /tmp/m2h/commands."$file"

    while read command ; do
	if [ -e "$Outputdir/$command".html ] ; then
	    my_echo "$command deja traite" #attention a la boucle infinie :-)
	else decomp_convertir "`man -W -c $command`"
	fi
    done < /tmp/m2h/commands."$file"

else my_echo "pas de page liee"
fi
}


#creation des liens vers d'autres pages eventuellement (et ce dans toute la page : c'est plus simple!)
traiter_hypertxt() {
if [ "$Hypertext" ] ; then
    echo $1 | sed "s/\([^\ ][^\ ]*\)\(([1-9])\)/<A\ HREF=\"\1\.html\">\1\2<\/A>/g"
else echo $1 
fi
}


#pour ne pas faire de html...
convertir_txt() {
 my_echo "Conversion de $1"
 name_of_file=`echo $1 | sed "s/.*\///" | sed "s/\..*//"`
 cat $1 > /tmp/m2h/temp2."$name_of_file"
 traiter_echap_txt /tmp/m2h/temp2."$name_of_file" /tmp/m2h/temp."$name_of_file"
 while read line ; do
    case "$line" in
	.\"*)
	    continue ;;
	.TH* | .th*)
	    continue ;;
	.*)
       text="`echo $line | (read ma te ; echo $te)`"
       echo "$text" >> "$Outputdir/$name_of_file".txt ;;
    esac
 done < /tmp/m2h/temp."$name_of_file"

}


#le vrai :
convertir_html() {
 my_echo "Conversion de $1"
 name_of_file=`echo $1 | sed "s/.*\///" | sed "s/\..*//"` #plus de chemin ni d'extensions
 get_info $1 #collecte des donnees
 echo "
<HTML> 
 <HEAD> 
  <TITLE>Manpage of $title</TITLE> 
 </HEAD>
 <BODY>
  <H1>$title</H1>
  <P>
  Section: $manual $section 
  <BR>Updated: $date" > "$Outputdir/$name_of_file".html
 if [ "$TopIndex" ] ; then #cas de l'index interne au fichier
    echo "<HR><H2>Summary: </H2>" >> "$Outputdir/$name_of_file".html
    cat $1 | grep ^\.SH > /tmp/m2h/topindex."$name_of_file" #on repertorie les diverses sections
    while read line ; do
    name=`echo $line | sed s/\.SH\ // | sed s/\"//g` #le nom de la section : "name"
    name2=`echo $name | sed s/^/#/` #pour le tag : "#name"
    echo "<H3><A HREF=\"$name2\">$name</A></H3>" >> "$Outputdir/$name_of_file".html
    done < /tmp/m2h/topindex."$name_of_file"
 else echo "<!- No Index ->" >> "$Outputdir/$name_of_file".html #juste pour le plaisir de mettre un else...
 fi
 cat $1 | grep -v ^$ > /tmp/m2h/temp2."$name_of_file" #suppression des lignes vides en vue du read

 traiter_echap /tmp/m2h/temp2."$name_of_file" /tmp/m2h/temp."$name_of_file" #traitement des sequences d'echappement
 while read line ; do 
   case "$line" in #les macros! les macros!
     .\"*)
       # Commentaire 
       continue ;;
     .TH* | .th*)
       # .TH title section date source manual 
       continue ;;
     .SH* | .sh*)
       # .SH section
       text=`echo $line | sed s/\"//g | (read ma te ; echo $te)` #on vire la macro et les guillemets eventuels (c'est pas beau)
       if [ "$TopIndex" ] ; then echo "<HR><H2><A NAME=\"$text\">$text</A></H2>" >> "$Outputdir/$name_of_file".html #ne pas oublier l'index
       else echo "<HR><H2>$text</H2>" >> "$Outputdir/$name_of_file".html
       fi ;;
     .BI* | .bi*)
       text="`echo $line | (read ma te ; echo $te)`"
       text=`echo "$text" | sed "s/^/<B>/" | sed "s/$/<\/B>/"`
	while [ "`echo "$text" | grep \ `" ] ; do
	    text=`echo "$text" | sed "s/\ /<\/B><I>/" | sed "s/<\/B>$/<\/I>/"`
	    text=`echo "$text" | sed "s/\ /<\/I><B>/" | sed "s/<\/I>$/<\/B>/"`
	done
       echo "$text" >>  "$Outputdir/$name_of_file".html ;;
     .R* | .r*)
       text="`echo $line | (read ma te ; echo $te)`"
       echo "$text" >> "$Outputdir/$name_of_file".html ;;
     .B* | .b*)
       text="`echo $line | (read ma te ; echo $te)`"
       echo "<B>$text</B>" >> "$Outputdir/$name_of_file".html ;;
     .I* | .i*)
       text="`echo $line | (read ma te ; echo $te)`"
       echo "<I>$text</I>" >> "$Outputdir/$name_of_file".html ;;
     .PP* | .LP* | .P*)
       text="`echo $line | (read ma te ; echo $te)`"
       echo "<P>$text" >> "$Outputdir/$name_of_file".html ;;
     .UR*)
       text="`echo $line | (read ma te ; echo $te)`"
       echo "<A HREF=\"$te\">" >> "$Outputdir/$name_of_file".html ;;
     .UE*)
       text="`echo $line | (read ma te ; echo $te)`"
       echo "</A>" >> "$Outputdir/$name_of_file".html ;;
     .SS*)
       text="`echo $line | (read ma te ; echo $te)`"
       echo "<H3>$text</H3>" >> "$Outputdir/$name_of_file".html ;;
     .TP*)
       text="`echo $line | (read ma te ; echo $te)`"
       echo "<P>$text" >> "$Outputdir/$name_of_file".html ;;
     .*)
       macro=`echo "$line" | (read m dummy ; echo $m)`
       my_echo "warning: Macro troff \"$macro\" inconnue ; ignoree"
       ;;
     *)
       traiter_hypertxt "$line" >> "$Outputdir/$name_of_file".html ;; #peut-etre y a-t-il des liens a creer?
   esac
 done < /tmp/m2h/temp."$name_of_file"

echo "<HR>Source: $source<P>Conversion by m2h.sh</BODY> </HTML>" >> "$Outputdir/$name_of_file".html #un peu d'autosatisfaction
if [ "$GlobalIndex" ] ; then my_echo "Ajout de $1  l'index"
fi
add_to_index "$name_of_file".html
if [ "$Recursive" ] ; then
    my_echo "Creation des pages liees"
    rec $1 #appel recursif vers les pages liees
else my_echo "abandon des pages liees"
fi
}


#explicite...
convertir() {
if [ $Mode = "Text" ] ; then convertir_txt $1
else convertir_html $1
fi
}


#decompression des fichiers avant traitement
decomp_convertir() {
ext=`echo "$1" | sed "s/^.*\.//"` #contient l'extention caracteristique de la compression
zfile=`echo "$1" | sed "s/.*\///"` #le fichier sans le chemin
file=`echo "$zfile" | sed "s/\.[^\.]*$//"` #le meme sans "ext"
cp "$1" "$Outputdir"
case "$ext" in
    gz) gunzip "$Outputdir/$zfile" ;;
    bz2) bunzip2 "$Outputdir/$zfile" ;;
    *) file="$file"."$ext"
esac 
convertir "$Outputdir/$file"
}


#debut du programme!
mkdir /tmp/m2h/ #creation d'un repertoire destine a contenir tous les fichiers de travail
while [ "`echo $1 | grep ^\-.*`" ]; do
    case "$1" in #traitement des options
    -f) Recursive="active"
        shift ;;
    -h) Hypertext="active" 
        shift ;;
    -i) TopIndex="active" 
        shift ;;
    -l) Logfile="$2" 
        shift 2 ;;
    -o) Outputdir=`echo "$2" | sed "s/\/$//"` #repertoire cible sans le slash final eventuel
        shift 2 ;;
    -s) Stylefile="$2" 
        shift 2 ;;
    -t) Mode="Text" 
        shift ;;
    -x) GlobalIndex="active" 
        shift ;;
    esac
done
if [ "$GlobalIndex" ] ; then
 my_echo "Creation de l'index"
 echo "<HTML><HEAD><TITLE>Index of man pages</TITLE></HEAD><BODY><H1>INDEX</H1>" > "$Outputdir/"index.html
fi
if [ -f $1 ] ; then #fichier en argument
 decomp_convertir $1
elif [ -d $1 ] ; then #repertoire en argument
 for I in "$1"/* ; do 
 decomp_convertir $I
 done
elif [ "`echo $1 | grep [0-9]`" ] ; then #section + commande en argument
 answer=`man -W -c $1 $2`
 if [ "$answer" ] ; then
    decomp_convertir "$answer"
 fi
else #commande seule en argument
 answer=`man -W -c $1`
 if [ "$answer" ] ; then
    decomp_convertir "$answer"
 fi
fi
if [ "$GlobalIndex" ] ; then
 echo "</BODY></HTML>" >> "$Outputdir/"index.html
fi

rm -f "$Outputdir/"*.[1-9] #nettoyage des fichiers decompresses
rm -rf /tmp/m2h/ #nettoyage des fichiers temporaires
#voila c'est fini